let AchievementNames = {
    EnjoyYourStay: 'EnjoyYourStay',
    Interviewer: 'Interviewer',
    EmploymentMachine: 'EmploymentMachine',
    YoureOut: 'YoureOut',
    YouAsWell: 'YouAsWell',
    Amateurs: 'Amateurs',
    DreamBig: 'DreamBig',
    Leader: 'Leader',
    EconomicSetback: 'EconomicSetback',
    Starvation: 'Starvation',
    IntoBlack: 'IntoBlack',
    ItsSomething: 'ItsSomething',
    SameButDifferent: 'SameButDifferent',
    InstallAllTheMods: 'InstallAllTheMods',
    ASmallLoan: "ASmallLoan"
};

Database.achievements = [
    {
        name: AchievementNames.EnjoyYourStay,
        trigger: (rootScope) => {
            return Helpers.GetAllEmployees(true).length > 0;
        }
    },
    {
        name: AchievementNames.Interviewer,
        trigger: (rootScope) => {
            return Helpers.GetAllEmployees(true).length >= 5;
        }
    },
    {
        name: AchievementNames.EmploymentMachine,
        trigger: (rootScope) => {
            return Helpers.GetAllEmployees(true).length >= 10;
        }
    },
    {
        name: AchievementNames.YoureOut,
        trigger: (rootScope) => {
            return rootScope.settings.firedEmployees.length > 0;
        }
    },
    {
        name: AchievementNames.YouAsWell,
        trigger: (rootScope) => {
            return rootScope.settings.firedEmployees.length >= 5;
        }
    },
    {
        name: AchievementNames.Amateurs,
        trigger: (rootScope) => {
            return rootScope.settings.firedEmployees.length >= 10;
        }
    },
    {
        name: AchievementNames.EconomicSetback,
        trigger: (rootScope) => {
            let lastCompletedContract = _.last(_.orderBy(rootScope.settings.contracts.filter(x => x.completionDay != null), x => x.completionDay));
            if(lastCompletedContract != null) {
                let currentDay = GetDateDiffInDays(rootScope.settings.date);
                if(currentDay > 14 && (currentDay - lastCompletedContract.completionDay) >= 14) {
                    return true;
                }
            }
            return false;
        }
    },
    {
        name: AchievementNames.Starvation,
        trigger: (rootScope) => {
            let lastCompletedContract = _.last(_.orderBy(rootScope.settings.contracts.filter(x => x.completionDay != null), x => x.completionDay));
            if(lastCompletedContract != null) {
                let currentDay = GetDateDiffInDays(rootScope.settings.date);
                if(currentDay > 30 && (currentDay - lastCompletedContract.completionDay) >= 30) {
                    return true;
                }
            }
            return false;
        }
    },
    {
        name: AchievementNames.IntoBlack,
        trigger: (rootScope) => {
            return rootScope.financeData != null && rootScope.financeData.profit.perMonth >= 0;
        }
    },
    {
        name: AchievementNames.ItsSomething,
        trigger: (rootScope) => {
            rootScope.settings.contracts.some(x => x.completionDay != null);
}
    },
    {
        name: AchievementNames.SameButDifferent,
        trigger: (rootScope) => {
            return rootScope.options.installedMods.length > 0;
        }
    },
    {
        name: AchievementNames.InstallAllTheMods,
        trigger: (rootScope) => {
            return rootScope.options.installedMods.length >= 5;
        }
    },
    {
        name: AchievementNames.ASmallLoan,
        trigger: (rootScope) => {
            return rootScope.settings.loans.some(x => x.active);
        }
    }
];

let RunAchievementTriggers = () => {
    let $rootScope = GetRootScope();
    if($rootScope == null) return;
    let completedAchievements = $rootScope.options.completedAchievements;
    Database.achievements.forEach(achievement => {
        if (!completedAchievements.includes(achievement.name)) {
            if (achievement.trigger($rootScope)) {
                completedAchievements.push(achievement.name);
                $rootScope.saveOptions();
                $rootScope.options.activeAchievement = achievement;

                // Activate Steam
                if (Remote.app.greenworks != null && Remote.app.greenworks.initAPI()) {
                    Remote.app.greenworks.activateAchievement(achievement.name, () => {
                    }, () => {
                    })
                }
            }
        }
    });
};